function CDX = CDX_interpolate_parameters(CDX, CDX2)
% --------------------------------------------------------------------------------------------------
% Use interpolation of parameters in 'CDX2' to fill parameters in 'CDX'
% --------------------------------------------------------------------------------------------------
% CDX       ... target of parameters
% CDX2      ... source of parameters
% --------------------------------------------------------------------------------------------------
% sample call: CDX_interpolate_parameters(cdx_tv_quarterly, cdx_tv_yearly)
% --------------------------------------------------------------------------------------------------

% CDX parameters
desired_dates = CDX.dates{1};
available_dates = CDX2.dates{1};
% y0
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.y0), desired_dates, 2);
CDX.y0 = TS_new.values;
% liq_prem_tranches
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.liq_prem_tranches), desired_dates, 2);
CDX.liq_prem_tranches = TS_new.values;
% liq_prem_cds
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.liq_prem_cds), desired_dates, 2);
CDX.liq_prem_cds = TS_new.values;
% AJD.k
CDX.AJD_common_factor.dates = desired_dates;
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.AJD_common_factor.k), desired_dates, 2);
CDX.AJD_common_factor.k = TS_new.values;
% AJD.theta
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.AJD_common_factor.theta), desired_dates, 2);
CDX.AJD_common_factor.theta = TS_new.values;
% AJD.sigma
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.AJD_common_factor.sigma), desired_dates, 2);
CDX.AJD_common_factor.sigma = TS_new.values;
% AJD.L
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.AJD_common_factor.L), desired_dates, 2);
CDX.AJD_common_factor.L = TS_new.values;
% AJD.mu
TS_new = TS_sample(struct('dates', available_dates, 'values', CDX2.AJD_common_factor.mu), desired_dates, 2);
CDX.AJD_common_factor.mu = TS_new.values;

% CDS parameters
tickers = {CDX.portfolio.ticker}';
tickers2 = {CDX2.portfolio.ticker}';
for i=1:length(CDX2.portfolio)
    % Match tickers
    pos = find(strcmp(tickers, tickers2{i}));
    if isempty(pos)
        continue;
    end
    
    % Copy interpolated parameters
    cds = CDX.portfolio(pos);
    cds2 = CDX2.portfolio(i);
    desired_dates = cds.dates{1};
    available_dates = cds2.dates{1};
    % x0
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.x0), desired_dates, 2);
    cds.x0 = TS_new.values;
    % ai
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.ai), desired_dates, 2);
    cds.ai = TS_new.values;
    % AJD.k
    cds.AJD.dates = desired_dates;
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.AJD.k), desired_dates, 2);
    cds.AJD.k = TS_new.values;
    % AJD.theta
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.AJD.theta), desired_dates, 2);
    cds.AJD.theta = TS_new.values;
    % AJD.sigma
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.AJD.sigma), desired_dates, 2);
    cds.AJD.sigma = TS_new.values;
    % AJD.L
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.AJD.L), desired_dates, 2);
    cds.AJD.L = TS_new.values;
    % AJD.mu
    TS_new = TS_sample(struct('dates', available_dates, 'values', cds2.AJD.mu), desired_dates, 2);
    cds.AJD.mu = TS_new.values;
    
    % Re-insert CDS into CDX
    CDX.portfolio(pos) = cds;
end



